title       VCCC2025 - Vintage Computing Christmas Challenge 2025

comment $

see https://logiker.com/Vintage-Computing-Christmas-Challenge-2025

Target: print following image with minimal executable code as possible

         *
       * * *
  * *   ***   * *
   **    *    **
  ***  * * *  ***
     *  ***  *
      *  *  *
 *  *  * * *  *  *
  *  *  ***  *  *
*******************
  *  *  ***  *  *
 *  *  * * *  *  *
      *  *  *
     *  ***  *
  ***  * * *  ***
   **    *    **
  * *   ***   * *
       * * *
         *


Realization:
First quarter (A) is filled based on a pattern table.
Once a single star is set, it is rotated to the other 3 quarters (B, C, D).

+-----+-----+
|     |     |
|  C  |  B  |
|     |     |
+-----+-----+
|     |     |
|  D  |  A  |
|     |     |
+-----+-----+

register usage:
  ah: int 10h function
  al: holds actual bitstring, character to be printed
  bh: page no
  bl: unused
  cx: loop counter
  dh: position row
  dl: position column
  si: pointer to pattern table

    $

PAGE
.model tiny                     ; generate .com program
.286
.code                           ; code segment
    org     100h                ; code starts at offset 100h	
main proc near                  ; main procedure
    mov     si,offset pattern   ; ds:si points to pattern
    mov     cx,8                ; 8 characters to be processed from pattern
    
rowloop:
    mov     dh,cl               ; use counter value for row
    push    cx                  ; save row counter
    mov     cl,8                ; 8 bits in pattern
    lodsb                       ; load pattern byte

columnloop:    
    mov     dl,cl               ; use counter value for column
    shl     al,1                ; shift pattern 1 bit left (first bit moved to carry flag)
    jnc     @f                  ; no carry, no star
    call    rotate              ; print rotated 4 times

@@:    
    loop    columnloop          ; next column
    
    pop     cx                  ; restore row counter
    loop    rowloop             ; next row
    
    xor     dx,dx              ; clear position

    mov     cl,9                ; counter, line length = 9

@@:
    call    rotate              ; print rotated 4 times
    inc     dl                  ; next y position
    loop    @b                  ; next column

rotate:
      push  ax                  ; save register
      push  cx                  ; save counter
      mov   cl,4                ; rotate 4 times so original position is back
      
@@:                       
      push  dx                  ; save position
      add   dh,0ch              ; add vertical alignment
      add   dl,28h              ; add horizontal alignment
      mov   ah,02h              ; function 'set cursor position'
      xor   bh,bh               ; page no. 0
      int   10h                 ; go!
      mov   ax,0e2ah            ; function 'teletype output', character "*"
      int   10h                 ; go!
      pop   dx                  ; restore position

; rotate position by 90 degree counterclockwise (dl = dh, dh = -dl)
      xchg  dh,dl               ; exchange dh and dl
      neg   dh                  ; set dh = minus dh
      
      loop  @b                  ; next 90 degree rotation
      
      pop   cx                  ; restore counter
      pop   ax                  ; restore register
      ret                       ; return to caller

pattern db  00000010b           ; ......*.
        db  01010001b           ; .*.*...*
        db  00110000b           ; ..**....
        db  01110010b           ; .***..*.
        db  00001001b           ; ....*..*
        db  00000100b           ; .....*..
        db  10010010b           ; *..*..*.
        db  01001001b           ; .*..*..*

main endp 
end main

